

CompScans_95toA_MQ <- function(dataf,datafA){
  
  datafA$Unique_scan <- paste0(datafA$Spectrum,"_",datafA$Retention.time) 
  dataf$Unique_scan <- paste0(dataf$Spectrum,"_",dataf$Retention.time) 
  dataf$SiteID <- paste0(dataf$Unique_scan,"_", dataf$PTM.positions)
  datafA$SiteID <- paste0(datafA$Unique_scan,"_", datafA$PTM.positions)
  
dataf$Peptidoform <- paste0(dataf$Modified.sequence,"_", dataf$PTM.positions)

dataf_pform <- dataf %>% group_by(Peptidoform) %>% top_n(1, PTM_final_prob)

dataf_95_pform <- dataf_pform[dataf_pform $PTM_final_prob>=0.95,]

Reduceddataf_95 <- subset(dataf_95_pform,select = c(Unique_scan,Sequence,PTM.positions,PTM_final_prob))

Reduceddataf_95 <- Reduceddataf_95 %>% dplyr::rename(
  pSTY_Score = PTM_final_prob
)

ReduceddatafA <- subset(datafA,select = c(Unique_scan,Sequence,PTM.positions,PTM_final_prob))

ReduceddatafA <- ReduceddatafA %>% dplyr::rename(
  SequenceSTYA = Sequence,
  PTM.positionsSTYA = PTM.positions,
  pASTY_Score = PTM_final_prob
)


dataf_Merged_95 <- merge(x=Reduceddataf_95,y=ReduceddatafA,by="Unique_scan", all.x = TRUE)

dataf_Merged_95$SeqMatch <- ifelse(dataf_Merged_95$Sequence==dataf_Merged_95$SequenceSTYA,1,0)

NoMatchSeq_95 <- subset(dataf_Merged_95,SeqMatch==0 | is.na(SeqMatch))

MatchSeq_95 <- subset(dataf_Merged_95,SeqMatch==1 )

Scans_NMSeq_95 <- length(unique(NoMatchSeq_95$Unique_scan))

Scans_MSeq_95 <- length(unique(MatchSeq_95$Unique_scan))


dataf_pform_95_Site <- dataf_95_pform[dataf_95_pform$Unique_scan %in% MatchSeq_95$Unique_scan,]

Reduceddataf_95_Site <- subset(dataf_pform_95_Site,select = c(SiteID,Sequence,PTM_final_prob, PTM.positions))

Reduceddataf_95_Site <- Reduceddataf_95_Site %>% dplyr::rename(
  pASTY_Score = PTM_final_prob
)
ReduceddatafA_Site <- subset(datafA,select = c(SiteID,Sequence,PTM_final_prob, PTM.positions))

ReduceddatafA_Site <- ReduceddatafA_Site %>% dplyr::rename(
  SequenceSTYA = Sequence,
  PTM.positionsSTYA = PTM.positions,
  pASTY_Score = PTM_final_prob
)

dataf_Merged_95_Site <- merge(x=Reduceddataf_95_Site,y=ReduceddatafA_Site,by="SiteID", all.x = TRUE)

MatchSeq_MSites_95 <- length(dataf_Merged_95_Site$SequenceSTY[!is.na(dataf_Merged_95_Site$SequenceSTYA)])

MatchSeq_NoMSites_95 <- length(dataf_Merged_95_Site$SequenceSTY[is.na(dataf_Merged_95_Site$SequenceSTYA)])

NoMatchSeq_NoMSites_95 <- length(dataf_95_pform$Unique_scan)-length(dataf_Merged_95_Site$SiteID)

Results_95 <- rbind(Scans_NMSeq_95,Scans_MSeq_95,MatchSeq_MSites_95,MatchSeq_NoMSites_95,NoMatchSeq_NoMSites_95)

return(Results_95)

}